# ASP.NET Readme

This folder contains a sample with i-net Clear Reports as background server.

## System Requirements

  * A installation of i-net Clear Reports for Java or i-net Clear Reports .Net
  * IIS with ASP.NET as the web server

## Installation

If the i-net Clear Reports installation is on the same server as the IIS use the setup tool for an automatic installation. If IIS and i-net Clear Reports should be installed on different servers the IIS needs to be configured manually.

#### i-net Clear Reports and IIS on the same server (automatic)

  * Install i-net Clear Reports with the setup tool (execute setup.exe) on the web server with the IIS.
  * Select the following components during installation:
    * "Microsoft IIS mit ASP.NET"
    * required database drivers and JavaBeans.

The setup creates a virtual directory with the name you specified during setup and copies the ASP.NET files into this virtual directory.

#### i-net Clear Reports and IIS on different servers (manual)

  * Install i-net Clear Reports with the setup tool (execute setup.exe).
  * Select the following components during installation:
    * "Standalone Server as Windows Service"
    * required database drivers and JavaBeans
    * Documentation and Samples
  * Create a virtual directory with the Internet Information Services Manager, e.g. `"clearreports"`.
  * Copy the sample files from the "ASP.NET" sample into the root of this virtual directory `"clearreports"`.
    * You can find the files in the directory: `"<cc_install_dir>\\documentation\\samples\\asp.net"`.
  * Change the location of the i-net Clear Reports server and the port number (if necessary) in the file default.aspx.

## Execute the Sample

  * Enter the URL `"http://<ServerName>/clearreports/?report=file:<path_of_report>.rpt"` in the address line of a browser to display a report.
  * Replace `<ServerName>` with the name of your web server, `"clearreports"` with the name of your virtual directory and <path_of_report> with a file path that is accessible for the i-net Clear Reports server, e.g. `http://localhost/clearreports/?report=file:c:/MyReports/sample.rpt`.

## Performance Tip

The performance will be better if clearreports.vb is compiled to a DLL (e.g. with Visual Studio) and be used on the IIS

